
/*************************************************** 
  This is a library for the Microdul Eval-Bord MS1008
  MS1088 is a ultra low power temperature sensor

  See:
  ----> https://www.microdul.com/de/assets/public/images/content/90311756.pdf

  Written by Wilfried.Hasselberg for Microdul AG.  
  BSD license, all text above must be included in any 
  redistribution
 ****************************************************/

#include "ebMS1088.h"

ebMS1088::ebMS1088() {
  // disable pullups for SDA and SCL
  digitalWrite(A4, LOW);
  digitalWrite(A5, LOW);
  TWBR = 72;
}


float ebMS1088::getTemperature(void) {
  float Tempval;
  startMeasurement();
  delay(MEASURE_DURATION);
  Tempval=readTemperature();
  return Tempval;
}

void ebMS1088::startMeasurement(void) {
  Wire.beginTransmission(EBMS1088_I2CADDR);
  Wire.write(byte(EBMS1088_START_TMEAS));
  Wire.endTransmission();
}

float ebMS1088::readTemperature(void) {
  float Tempval;
  long int Tdata;
  Wire.beginTransmission(EBMS1088_I2CADDR);
  Wire.write(byte(EBMS1088_READ_T));
  Wire.endTransmission();
  Wire.requestFrom(EBMS1088_I2CADDR,2);
  Tdata = Wire.read();  
  Tdata = Tdata << 8;    
  Tdata |= Wire.read(); 
  Wire.endTransmission();
  // Drop ECC
  Tdata = Tdata >> 4;
  // Calculate temperature:
  Tempval = Tdata;
  Tempval = Tempval/20 - 80;
  return Tempval;
}

void ebMS1088::resetMS1088(void) {
  Serial.print("  ebMS1088 reset ");
  Wire.beginTransmission(EBMS1088_I2CADDR);
  Wire.write(byte(EBMS1088_RESET));
  Wire.endTransmission();
  Serial.println("  ... done");
}

void ebMS1088::initMS1088(void) {
  Serial.println("Microdul AG, V0.1");
  Serial.println("ebMS1088 init .. ");
  resetMS1088();
  startMeasurement();  
  Serial.println("... done");
}


