/*************************************************** 
  This is a library for the Microdul Eval-Bord MS1008
  MS1088 is a ultra low power temperature sensor

  See:
  ----> https://www.microdul.com/de/assets/public/images/content/90311756.pdf

  Written by Wilfried.Hasselberg for Microdul AG.  
  BSD license, all text above must be included in any 
  redistribution
 ****************************************************/

#ifndef EBMS1088_H
#define EBMS1088_H

#if (ARDUINO >= 100)
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
#include "Wire.h"

#define EBMS1088_I2CADDR         0x48  // I2C-address

#define EBMS1088_READ_T          0x00  // R   Temperature data (16 bits)

#define EBMS1088_START_TMEAS     0x01  // W   Start Measurement
#define EBMS1088_RESET           0x03  // W   Reset the MS1088

#define MEASURE_DURATION         1000  // duration of the measurement

class ebMS1088 {
 public:
  ebMS1088();
  float getTemperature(void);
  void startMeasurement(void);
  float readTemperature(void);
  void resetMS1088(void);
  void initMS1088(void);
};


#endif // EBMS1088_H

