#include <Wire.h>
#include <ebMS1088.h>

/*************************************************** 
  This is an example for the Temp Sensor MS1088

  Designed specifically to work with the Breakout Board
  EvalBorad-MS1088
  ----> https://www.microdul.com/de/assets/public/images/content/90311756.pdf

  Written by Wilfried.Hasselberg for Microdul
  BSD license, all text above must be included in any redistribution
 ****************************************************/

//---------------------------------------------------------------------------------------
// Connect VCC of the EBMS1088 sensor to 3.3V (NOT 5.0V!)
// Connect GND to Ground
// Connect SCL to i2c clock - on '168/'328 Arduino Uno/Duemilanove/etc thats Analog 5
// Connect SDA to i2c data - on '168/'328 Arduino Uno/Duemilanove/etc thats Analog 4
//---------------------------------------------------------------------------------------


ebMS1088 eb1088;
  
void setup() {
  Serial.begin(9600);
  eb1088.initMS1088();
}
  
void loop() {
    Serial.print("Temperature = ");
    Serial.print(eb1088.getTemperature());
    Serial.println(" *C");
    Serial.println();
    delay(1000);
}
